<?php
require_once( "Constants.class.php" ) ;
require_once( "CommonUtility.class.php" ) ;
require_once( "ConfManager.class.php" ) ;
require_once( "DbManager.class.php" ) ;
require_once( "MsManager.class.php" ) ;

function wait_all_processing_samples_done( $argv ) {

    $ret = 0 ;
    try {

        # reset isActive=0 for all existing vm path
        DbManager::query(
            "UPDATE tb_global_setting
             SET    value = 0
             WHERE  key LIKE 'configuration.image_type.image_%.isActive'" ) ;

        
        # wait reset_ms_and_sc_for_reconfig_sb done
        CommonUtility::debug_print( "waiting 'extract_email.pl' deleting related information on both MS and SC side." ) ;
        $count    = 0 ;
        $interval = 30 ;
        while( true ) {
        
            CommonUtility::debug_print( "Sleep ${interval} seconds for next try ... ($count/oo)" ) ;
            sleep( $interval ) ;
            $count += 1 ;
            
            # query crond status and it should be 'stopped'
            CommonUtility::debug_print( "QueryCrondStatus" ) ;
            $retArray = MsManager::runProgramBySsh( 1, array(
                'program'   => '/sbin/service',
                'arguments' => array(
                    'crond',
                    'status' ) ) ) ;
            $stdoutMsg = join( " ", $retArray[ 1 ] ) ;
            if( $stdoutMsg != "crond is stopped" ) {
                CommonUtility::debug_print( "CrondNotStopped: msg='$stdoutMsg'" ) ;
                continue ;
            }
            CommonUtility::debug_print( "CrondStopped: msg='$stdoutMsg'" ) ;

            
            # Check if table 'tb_file_record' and 'tb_file_history' have been cleaned
            $sqlCmd = "SELECT count(*) FROM tb_file_record" ;
            CommonUtility::debug_print( "QueryFileRecordCount: sqlCmd='$sqlCmd'" ) ;
            $qResultArray = pg_fetch_array(
                DbManager::query( $sqlCmd ),
                null,
                PGSQL_NUM ) ;
            $fileRecordCount = $qResultArray[ 0 ] ;
            CommonUtility::debug_print( "fileRecordCount='$fileRecordCount'" ) ;
            
            $sqlCmd = "SELECT count(*) FROM tb_file_history" ;
            CommonUtility::debug_print( "QueryFileHistoryCount: sqlCmd='$sqlCmd'" ) ;
            $qResultArray = pg_fetch_array(
                DbManager::query( $sqlCmd ),
                null,
                PGSQL_NUM ) ;
            $fileHistoryCount = $qResultArray[ 0 ] ;
            CommonUtility::debug_print( "fileHistoryCount='$fileHistoryCount'" ) ;
            
            if( $fileRecordCount + $fileRecordCount != 0 ) {
                continue ;
            }

            
            # check if process 'stop_services_at_ms_and_sc.inc' still exists
            CommonUtility::debug_print( "QueryStopMsAndScServiceStatus" ) ;
            $retArray = MsManager::runProgramBySsh( 1, array(
                'program'   => '/bin/ps aux | grep -v grep | grep "stop_services_at_ms_and_sc"',
            ) ) ;
            $retCode   = $retArray[ 0 ] ;
            $stdoutMsg = join( " ", $retArray[ 1 ] ) ;
            if( $retCode == 0 ) {
                CommonUtility::debug_print( "QueryStopMsAndScServiceStatus: InProgress, msg='$stdoutMsg'" ) ;
                continue ;
            }
            CommonUtility::debug_print( "QueryStopMsAndScServiceStatus: Done" ) ;
            
            
            # check if process 'reset_ms_and_sc_for_reconfig_sb.inc' still exists
            CommonUtility::debug_print( "QueryResetMsAndScForReconfigSbStatus" ) ;
            $retArray = MsManager::runProgramBySsh( 1, array(
                'program'   => '/bin/ps aux | grep -v grep | grep "reset_ms_and_sc_for_reconfig"',
            ) ) ;
            $retCode   = $retArray[ 0 ] ;
            $stdoutMsg = join( " ", $retArray[ 1 ] ) ;
            if( $retCode == 0 ) {
                CommonUtility::debug_print( "QueryResetMsAndScForReconfigSbStatus: InProgress, msg='$stdoutMsg'" ) ;
                continue ;
            }
            CommonUtility::debug_print( "QueryResetMsAndScForReconfigSbStatus: Done" ) ;
            
            
            # all checking points are passed
            break ;
        }
        CommonUtility::debug_print( "waiting extract_email.pl done." ) ;
    }
    
    catch( Exception $e ) {
        debug_print( "Exception caught: " . $e->getMessage() ) ;
        echo 'pg_query: ' . $e->getMessage() ;
        $ret = 1 ;
    }

    DbManager::closeConnection() ;
    exit( $ret ) ;
}
